using System;
using System.Collections;
using Server.Items;
using Server.Targeting;

namespace Server.Mobiles
{
	//[CorpseName( "a frost troll corpse" )]
	public class IceTroll : FrostTroll
	{
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.CrushingBlow;
					case 1: return WeaponAbility.ArmorIgnore;
					case 2: return WeaponAbility.ParalyzingBlow;
			}
		}
      
      [Constructable]
		public IceTroll() : base()
		{
			Name = "snezny troll";
         Body = Utility.RandomList( 53, 54 );
         Hue = 1150;
         SetStr( 700, 745 );
			SetDex( 120, 130 );

			SetHits( 1500, 2000 );

			SetDamage( 20, 30 );

			SetResistance( ResistanceType.Physical, 50, 70 );
			SetResistance( ResistanceType.Cold, 60, 70 );
			SetResistance( ResistanceType.Poison, 100 );
			SetResistance( ResistanceType.Energy, 40, 70 );
			SetResistance( ResistanceType.Fire, 40, 70 );

			SetSkill( SkillName.MagicResist, 125.1, 140.0 );
			SetSkill( SkillName.Tactics, 90.1, 120.0 );
			SetSkill( SkillName.Wrestling, 90.1, 120.0 );
			SetSkill( SkillName.Anatomy, 90.1, 120.0 );

			VirtualArmor = 55;
		}

		public override Poison PoisonImmune{ get{ return Poison.Regular; } }
		public override int TreasureMapLevel{ get{ return 3; } }
		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override bool IsNotScaredOfDeath{ get{ return false; } } //neutika pri malem poctu hp

		public IceTroll( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}